(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     33062,       1031]*)
(*NotebookOutlinePosition[     33716,       1054]*)
(*  CellTagsIndexPosition[     33672,       1050]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(f[x_] = x\ IntegerPart[1/x]\)], "Input"],

Cell[BoxData[
    \(A1 = Plot[f[x], {x, 1, 1.5}]\)], "Input"],

Cell[BoxData[
    \(A2 = Plot[f[x], {x, 1/2, 1}]\)], "Input"],

Cell[BoxData[
    \(A3 = Plot[f[x], {x, 1/3, 1/2}]\)], "Input"],

Cell[BoxData[
    \(A4 = Plot[f[x], {x, 1/4, 1/3}]\)], "Input"],

Cell[BoxData[
    \(A5 = Plot[f[x], {x, 1/5, 1/4}]\)], "Input"],

Cell[BoxData[
    \(A6 = Plot[f[x], {x, 1/6, 1/5}]\)], "Input"],

Cell[BoxData[
    \(A7 = Plot[f[x], {x, 1/7, 1/6}]\)], "Input"],

Cell[BoxData[
    \(A8 = Plot[f[x], {x, 1/8, 1/7}]\)], "Input"],

Cell[BoxData[
    \(A9 = Plot[f[x], {x, 1/9, 1/8}]\)], "Input"],

Cell[BoxData[
    \(B1 = Plot[\(-z\), {z, \(-1.5\), \(-1\)}]\)], "Input"],

Cell[BoxData[
    \(B2 = Plot[f[x] - x, {x, \(-1\), \(-1\)/2}]\)], "Input"],

Cell[BoxData[
    \(B3 = Plot[f[x] - x, {x, \(-1\)/2, \(-1\)/3}]\)], "Input"],

Cell[BoxData[
    \(B4 = Plot[f[x] - x, {x, \(-1\)/3, \(-1\)/4}]\)], "Input"],

Cell[BoxData[
    \(B5 = Plot[f[x] - x, {x, \(-1\)/4, \(-1\)/5}]\)], "Input"],

Cell[BoxData[
    \(B6 = Plot[f[x] - x, {x, \(-1\)/5, \(-1\)/6}]\)], "Input"],

Cell[BoxData[
    \(B7 = Plot[f[x] - x, {x, \(-1\)/6, \(-1\)/7}]\)], "Input"],

Cell[BoxData[
    \(C1 = 
      Graphics[{Dashing[{0.03, 0.03}], 
          Line[{{\(-1.5\), 1}, {1.5, 1}}]}]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[{A1, A2, A3, A4, A5, A6, A7, A8, A9, B1, B2, B3, B4, B5, B6, B7, 
        C1}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.31746 0.0147151 0.294302 [
[.02381 .00222 -12 -9 ]
[.02381 .00222 12 0 ]
[.18254 .00222 -6 -9 ]
[.18254 .00222 6 0 ]
[.34127 .00222 -12 -9 ]
[.34127 .00222 12 0 ]
[.65873 .00222 -9 -9 ]
[.65873 .00222 9 0 ]
[.81746 .00222 -3 -9 ]
[.81746 .00222 3 0 ]
[.97619 .00222 -9 -9 ]
[.97619 .00222 9 0 ]
[.4875 .16187 -18 -4.5 ]
[.4875 .16187 0 4.5 ]
[.4875 .30902 -6 -4.5 ]
[.4875 .30902 0 4.5 ]
[.4875 .45617 -18 -4.5 ]
[.4875 .45617 0 4.5 ]
[.4875 .60332 -6 -4.5 ]
[.4875 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .01472 m
.02381 .02097 L
s
[(-1.5)] .02381 .00222 0 1 Mshowa
.18254 .01472 m
.18254 .02097 L
s
[(-1)] .18254 .00222 0 1 Mshowa
.34127 .01472 m
.34127 .02097 L
s
[(-0.5)] .34127 .00222 0 1 Mshowa
.65873 .01472 m
.65873 .02097 L
s
[(0.5)] .65873 .00222 0 1 Mshowa
.81746 .01472 m
.81746 .02097 L
s
[(1)] .81746 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(1.5)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.05556 .01472 m
.05556 .01847 L
s
.0873 .01472 m
.0873 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.15079 .01472 m
.15079 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.24603 .01472 m
.24603 .01847 L
s
.27778 .01472 m
.27778 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.37302 .01472 m
.37302 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.43651 .01472 m
.43651 .01847 L
s
.46825 .01472 m
.46825 .01847 L
s
.53175 .01472 m
.53175 .01847 L
s
.56349 .01472 m
.56349 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.62698 .01472 m
.62698 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.72222 .01472 m
.72222 .01847 L
s
.75397 .01472 m
.75397 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.84921 .01472 m
.84921 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.9127 .01472 m
.9127 .01847 L
s
.94444 .01472 m
.94444 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.5 .16187 m
.50625 .16187 L
s
[(0.5)] .4875 .16187 1 0 Mshowa
.5 .30902 m
.50625 .30902 L
s
[(1)] .4875 .30902 1 0 Mshowa
.5 .45617 m
.50625 .45617 L
s
[(1.5)] .4875 .45617 1 0 Mshowa
.5 .60332 m
.50625 .60332 L
s
[(2)] .4875 .60332 1 0 Mshowa
.125 Mabswid
.5 .04415 m
.50375 .04415 L
s
.5 .07358 m
.50375 .07358 L
s
.5 .10301 m
.50375 .10301 L
s
.5 .13244 m
.50375 .13244 L
s
.5 .1913 m
.50375 .1913 L
s
.5 .22073 m
.50375 .22073 L
s
.5 .25016 m
.50375 .25016 L
s
.5 .27959 m
.50375 .27959 L
s
.5 .33845 m
.50375 .33845 L
s
.5 .36788 m
.50375 .36788 L
s
.5 .39731 m
.50375 .39731 L
s
.5 .42674 m
.50375 .42674 L
s
.5 .4856 m
.50375 .4856 L
s
.5 .51503 m
.50375 .51503 L
s
.5 .54446 m
.50375 .54446 L
s
.5 .57389 m
.50375 .57389 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.81746 .01472 m
.8239 .01472 L
.83092 .01472 L
.83752 .01472 L
.84386 .01472 L
.85061 .01472 L
.85711 .01472 L
.86402 .01472 L
.87067 .01472 L
.87708 .01472 L
.88389 .01472 L
.89044 .01472 L
.89675 .01472 L
.90347 .01472 L
.90993 .01472 L
.9168 .01472 L
.92342 .01472 L
.92978 .01472 L
.93656 .01472 L
.94308 .01472 L
.95001 .01472 L
.95669 .01472 L
.96311 .01472 L
.96994 .01472 L
.97619 .01472 L
s
.65873 .16187 m
.66517 .16784 L
.67219 .17435 L
.67879 .18046 L
.68513 .18634 L
.69188 .1926 L
.69838 .19862 L
.70529 .20503 L
.71194 .2112 L
.71835 .21713 L
.72516 .22345 L
.73171 .22953 L
.73802 .23537 L
.74474 .2416 L
.7512 .24759 L
.75807 .25396 L
.76469 .26009 L
.77105 .26599 L
.77783 .27227 L
.78435 .27832 L
.79128 .28474 L
.79796 .29093 L
.80438 .29689 L
.81121 .30323 L
.81746 .30902 L
s
.60582 .21092 m
.60797 .2149 L
.61031 .21924 L
.61251 .22331 L
.61462 .22723 L
.61687 .2314 L
.61904 .23542 L
.62134 .23969 L
.62356 .2438 L
.62569 .24776 L
.62796 .25197 L
.63015 .25602 L
.63225 .25992 L
.63449 .26407 L
.63664 .26806 L
.63893 .27231 L
.64114 .2764 L
.64326 .28033 L
.64552 .28452 L
.64769 .28855 L
.65 .29284 L
.65223 .29696 L
.65437 .30093 L
.65665 .30516 L
.65873 .30902 L
s
.57937 .23544 m
.58044 .23843 L
.58161 .24168 L
.58271 .24474 L
.58377 .24768 L
.58489 .25081 L
.58597 .25382 L
.58712 .25702 L
.58823 .26011 L
.5893 .26307 L
.59044 .26623 L
.59153 .26927 L
.59258 .27219 L
.5937 .27531 L
.59478 .2783 L
.59592 .28149 L
.59702 .28455 L
.59809 .28751 L
.59921 .29065 L
.6003 .29367 L
.60146 .29688 L
.60257 .29998 L
.60364 .30295 L
.60478 .30612 L
.60582 .30902 L
s
.56349 .25016 m
.56414 .25254 L
.56484 .25515 L
.5655 .25759 L
.56613 .25995 L
.56681 .26245 L
.56746 .26486 L
.56815 .26742 L
.56881 .26989 L
.56945 .27226 L
.57013 .27479 L
.57079 .27722 L
.57142 .27956 L
.57209 .28205 L
.57274 .28445 L
.57343 .28699 L
.57409 .28945 L
.57472 .29181 L
.5754 .29432 L
.57605 .29674 L
.57675 .29931 L
.57741 .30178 L
.57806 .30417 L
.57874 .3067 L
.57937 .30902 L
s
.55291 .25997 m
.55334 .26196 L
.55381 .26413 L
.55425 .26616 L
.55467 .26812 L
.55512 .27021 L
.55555 .27222 L
.55601 .27435 L
.55646 .27641 L
.55688 .27839 L
.55734 .28049 L
.55778 .28252 L
.5582 .28447 L
.55864 .28654 L
.55907 .28854 L
.55953 .29066 L
.55997 .29271 L
.5604 .29468 L
.56085 .29677 L
.56128 .29878 L
.56175 .30093 L
.56219 .30299 L
.56262 .30498 L
.56308 .30709 L
.56349 .30902 L
s
.54535 .26697 m
.54566 .26868 L
.54599 .27054 L
.54631 .27229 L
.54661 .27397 L
.54693 .27575 L
.54724 .27748 L
.54757 .27931 L
.54789 .28107 L
.54819 .28276 L
.54851 .28457 L
.54883 .28631 L
.54913 .28798 L
.54945 .28975 L
.54975 .29147 L
.55008 .29329 L
.5504 .29504 L
.5507 .29672 L
.55102 .29852 L
.55133 .30025 L
.55166 .30208 L
.55198 .30385 L
.55229 .30555 L
.55261 .30736 L
.55291 .30902 L
s
.53968 .27223 m
.53991 .27372 L
.54016 .27535 L
.5404 .27688 L
.54063 .27835 L
.54087 .27991 L
.5411 .28142 L
.54135 .28302 L
.54158 .28456 L
.54181 .28605 L
.54205 .28762 L
.54229 .28914 L
.54251 .29061 L
.54275 .29216 L
.54298 .29366 L
.54323 .29525 L
.54347 .29679 L
.54369 .29826 L
.54394 .29983 L
.54417 .30134 L
.54442 .30295 L
.54465 .3045 L
.54488 .30599 L
.54513 .30757 L
.54535 .30902 L
s
.53527 .27632 m
.53545 .27764 L
.53565 .27909 L
.53583 .28045 L
.53601 .28176 L
.53619 .28315 L
.53637 .28449 L
.53657 .28591 L
.53675 .28728 L
.53693 .2886 L
.53712 .29 L
.5373 .29135 L
.53748 .29265 L
.53766 .29403 L
.53784 .29537 L
.53803 .29678 L
.53822 .29814 L
.53839 .29946 L
.53858 .30085 L
.53876 .3022 L
.53896 .30362 L
.53914 .305 L
.53932 .30632 L
.53951 .30773 L
.53968 .30902 L
s
.02381 .45617 m
.03025 .4502 L
.03727 .44369 L
.04387 .43757 L
.05021 .43169 L
.05696 .42544 L
.06346 .41941 L
.07037 .41301 L
.07702 .40684 L
.08342 .4009 L
.09024 .39459 L
.09679 .38851 L
.1031 .38266 L
.10981 .37644 L
.11628 .37045 L
.12315 .36408 L
.12977 .35794 L
.13613 .35204 L
.14291 .34576 L
.14943 .33971 L
.15636 .33329 L
.16303 .3271 L
.16946 .32114 L
.17629 .31481 L
.18254 .30902 L
s
.18254 .60332 m
.18898 .59138 L
.196 .57836 L
.2026 .56613 L
.20894 .55437 L
.21569 .54185 L
.22219 .5298 L
.2291 .517 L
.23575 .50466 L
.24215 .49279 L
.24897 .48016 L
.25552 .468 L
.26183 .45631 L
.26854 .44386 L
.27501 .43188 L
.28188 .41914 L
.2885 .40687 L
.29486 .39506 L
.30164 .3825 L
.30816 .37041 L
.31509 .35756 L
.32176 .34518 L
.32819 .33327 L
.33502 .3206 L
.34127 .30902 L
s
.34127 .45617 m
.34342 .4502 L
.34576 .44369 L
.34796 .43757 L
.35007 .43169 L
.35232 .42544 L
.35449 .41941 L
.35679 .41301 L
.35901 .40684 L
.36114 .4009 L
.36341 .39459 L
.3656 .38851 L
.3677 .38266 L
.36994 .37644 L
.37209 .37045 L
.37438 .36408 L
.37659 .35794 L
.37871 .35204 L
.38097 .34576 L
.38314 .33971 L
.38545 .33329 L
.38768 .3271 L
.38982 .32114 L
.3921 .31481 L
.39418 .30902 L
s
.39418 .40712 m
.39525 .40314 L
.39642 .3988 L
.39752 .39472 L
.39858 .3908 L
.39971 .38663 L
.40079 .38261 L
.40194 .37834 L
.40305 .37423 L
.40412 .37027 L
.40525 .36606 L
.40634 .36201 L
.40739 .35811 L
.40851 .35396 L
.40959 .34997 L
.41074 .34572 L
.41184 .34163 L
.4129 .3377 L
.41403 .33351 L
.41512 .32948 L
.41627 .3252 L
.41738 .32107 L
.41845 .3171 L
.41959 .31288 L
.42063 .30902 L
s
.42063 .38259 m
.42128 .37961 L
.42198 .37635 L
.42264 .3733 L
.42327 .37036 L
.42395 .36723 L
.4246 .36421 L
.42529 .36101 L
.42596 .35793 L
.4266 .35496 L
.42728 .3518 L
.42793 .34876 L
.42856 .34584 L
.42924 .34273 L
.42988 .33973 L
.43057 .33655 L
.43123 .33348 L
.43187 .33053 L
.43254 .32739 L
.4332 .32437 L
.43389 .32115 L
.43456 .31806 L
.4352 .31508 L
.43588 .31191 L
.43651 .30902 L
s
.43651 .36788 m
.43694 .36549 L
.43741 .36289 L
.43785 .36044 L
.43827 .35809 L
.43872 .35558 L
.43915 .35317 L
.43961 .35061 L
.44006 .34815 L
.44048 .34577 L
.44094 .34325 L
.44137 .34081 L
.44179 .33847 L
.44224 .33598 L
.44267 .33359 L
.44313 .33104 L
.44357 .32859 L
.444 .32623 L
.44445 .32371 L
.44488 .3213 L
.44534 .31873 L
.44579 .31625 L
.44622 .31387 L
.44667 .31133 L
.44709 .30902 L
s
.44709 .35807 m
.4474 .35608 L
.44773 .35391 L
.44805 .35187 L
.44835 .34991 L
.44867 .34782 L
.44898 .34581 L
.44931 .34368 L
.44962 .34162 L
.44993 .33965 L
.45025 .33754 L
.45057 .33551 L
.45087 .33357 L
.45119 .33149 L
.45149 .32949 L
.45182 .32737 L
.45214 .32533 L
.45244 .32336 L
.45276 .32126 L
.45307 .31925 L
.4534 .31711 L
.45372 .31504 L
.45403 .31306 L
.45435 .31095 L
.45465 .30902 L
s
[ .03 .03 ] 0 setdash
.02381 .30902 m
.97619 .30902 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X0000gQP00`40o`000?l0003o3Oooo`D00004
oooo0P0000Goool40000:_ooo`D0000Yoooo100000Goool200001Oooo`@0001Doooo100000Goool2
00001Oooo`@0000Zoooo1@0002Woool500001?ooo`800005oooo100000Ooool000ooool00`000?oo
ooooo`04oooo0P0000Coool00`000?ooooooo`02oooo00<0003oooooool0:Oooo`030000oooooooo
02Soool00`000?ooooooo`02oooo00<0003oooooool00_ooo`800004oooo00<0003oooooool00_oo
o`030000oooooooo053oool00`000?ooooooo`02oooo00<0003oooooool00_ooo`800004oooo00<0
003oooooool00_ooo`030000oooooooo02Woool00`000?ooooooo`0[oooo00<0003oooooool01?oo
o`800004oooo00<0003oooooool00_ooo`030000oooooooo00Coool000ooool00`000?ooooooo`0?
oooo00<0003oooooool0:Oooo`030000oooooooo02Soool00`000?ooooooo`02oooo00<0003ooooo
ool03Oooo`030000oooooooo053oool00`000?ooooooo`02oooo00<0003oooooool03Oooo`030000
oooooooo02Woool00`000?ooooooo`0[oooo00<0003oooooool03oooo`030000oooooooo00Coool0
00Coool600001Oooo`030000oooooooo00ooool00`000?ooooooo`0Noooo1P0000Goool00`000?oo
ooooo`0Poooo1P0000;oool00`000?ooooooo`02oooo00<0003oooooool03Oooo`030000oooooooo
053oool00`000?ooooooo`02oooo00<0003oooooool03Oooo`030000oooooooo02Woool00`000?oo
ooooo`0[oooo00<0003oooooool03oooo`030000oooooooo00Coool000ooool00`000?ooooooo`0;
oooo100002coool00`000?ooooooo`0Xoooo00<0003oooooool00_ooo`030000oooooooo00Woool4
0000Doooo`030000oooooooo00;oool00`000?ooooooo`09oooo100002coool00`000?ooooooo`0[
oooo00<0003oooooool02oooo`@00007oooo000?oooo00<0003oooooool02oooo`030000oooooooo
02goool00`000?ooooooo`0Xoooo00<0003oooooool00_ooo`030000oooooooo00Woool00`000?oo
ooooo`1Doooo00<0003oooooool00_ooo`030000oooooooo00Woool00`000?ooooooo`0]oooo00<0
003oooooool0:oooo`030000oooooooo00_oool00`000?ooooooo`08oooo000=oooo0`0000goool0
0`000?ooooooo`0[oooo0`0002[oool00`000?ooooooo`02oooo00<0003oooooool02Oooo`030000
oooooooo05Coool00`000?ooooooo`02oooo00<0003oooooool02Oooo`030000oooooooo02_oool3
0000:oooo`<0000=oooo00<0003oooooool02?ooo`003oooo`030000oooooooo00_oool50000:ooo
o`030000oooooooo02Woool400003?ooo`D0001Coooo100000coool50000:oooo`030000oooooooo
02_oool00`000?ooooooo`0;oooo1@0000Koool00?oooomYoooo003oooooJOooo`00ooooofWoool0
0;Goool00`000?ooooooo`2`oooo002eoooo00<0003oooooool0/?ooo`00]Oooo`030000oooooooo
0;3oool00;Goool00`000?ooooooo`2`oooo002eoooo00<0003oooooool0/?ooo`002oooool0001F
00002?ooo`004oooo`030000oooooooo00Soool00`000?ooooooo`07oooo00<0003oooooool02?oo
o`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo
00Ooool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?oo
ooooo`08oooo00<0003oooooool01oooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0
003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`07oooo00<0003oooooool02?oo
o`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo
00Ooool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?oo
ooooo`08oooo00<0003oooooool01oooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0
003oooooool02?ooo`030000oooooooo00koool001?oool00`000?ooooooo`0coooo00<0003ooooo
ool0<oooo`030000oooooooo03?oool00`000?ooooooo`0coooo00<0003oooooool0<oooo`030000
oooooooo03?oool00`000?ooooooo`0>oooo002eoooo00<0003oooooool0/?ooo`00]Oooo`030000
oooooooo0;3oool00;Goool00`000?ooooooo`2`oooo002eoooo00<0003oooooool0/?ooo`00]Ooo
o`030000oooooooo0;3oool00;Goool00`000?ooooooo`2`oooo002eoooo00<0003oooooool0/?oo
o`00]Oooo`80002aoooo002eoooo00<0003oooooool0/?ooo`00]Oooo`030000oooooooo0;3oool0
0;Goool00`000?ooooooo`2`oooo002eoooo00<0003oooooool0/?ooo`00]Oooo`030000oooooooo
0;3oool00;Goool00`000?ooooooo`2`oooo002eoooo00<0003oooooool0/?ooo`00]Oooo`030000
oooooooo0;3oool00;Goool00`000?ooooooo`2`oooo002eoooo0P000;7oool00;Goool00`000?oo
ooooo`2`oooo002eoooo00<0003oooooool0/?ooo`00]Oooo`030000oooooooo0;3oool00;Goool0
0`000?ooooooo`2`oooo002eoooo00<0003oooooool0/?ooo`00]Oooo`030000oooooooo0;3oool0
0;Goool00`000?ooooooo`2`oooo002eoooo00<0003oooooool0/?ooo`00]Oooo`030000oooooooo
0;3oool00;Goool20000/Oooo`00]Oooo`030000oooooooo0;3oool00;Goool00`000?ooooooo`2`
oooo002eoooo00<0003oooooool0/?ooo`00]Oooo`030000oooooooo0;3oool00;Goool00`000?oo
ooooo`2`oooo002eoooo00<0003oooooool0/?ooo`00]Oooo`030000oooooooo0;3oool00;Goool0
0`000?ooooooo`2`oooo002eoooo00<0003oooooool0/?ooo`00]Oooo`80002aoooo002eoooo00<0
003oooooool0/?ooo`00]Oooo`030000oooooooo0;3oool00;Goool00`000?ooooooo`2`oooo002e
oooo00<0003oooooool0/?ooo`00]Oooo`030000oooooooo0;3oool00;Goool00`000?ooooooo`2`
oooo002Koooo100000Goool200001Oooo`@00006oooo00<0003oooooool0/?ooo`00V_ooo`030000
oooooooo00;oool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`02oooo00<0003ooooo
ool00oooo`030000oooooooo0;3oool009[oool00`000?ooooooo`02oooo00<0003oooooool03Ooo
o`030000oooooooo00?oool00`000?ooooooo`2`oooo002Joooo00<0003oooooool00_ooo`030000
oooooooo00goool00`000?ooooooo`03oooo0`0003?oool00`000?ooooooo`1joooo002Joooo00<0
003oooooool00_ooo`030000oooooooo00Woool400001_ooo`030000oooooooo03Coool00`000?oo
ooooo`1ioooo002Joooo00<0003oooooool00_ooo`030000oooooooo00Woool00`000?ooooooo`07
oooo00<0003oooooool0=Oooo`030000oooooooo07Soool009[oool00`000?ooooooo`02oooo00<0
003oooooool02Oooo`030000oooooooo00Ooool00`000?ooooooo`0foooo00<0003oooooool0Mooo
o`00Voooo`@0000<oooo1@0000Goool00`000?ooooooo`0goooo00<0003oooooool0M_ooo`00]Ooo
o`030000oooooooo03Soool20000M_ooo`00]Oooo`030000oooooooo03[oool00`000?ooooooo`1c
oooo002eoooo00<0003oooooool0>oooo`030000oooooooo07;oool00;Goool00`000?ooooooo`0l
oooo00<0003oooooool0LOooo`00]Oooo`030000oooooooo03goool00`000?ooooooo`1`oooo002e
oooo0P0003ooool00`000?ooooooo`1_oooo002eoooo00<0003oooooool0?oooo`030000oooooooo
06koool00;Goool00`000?ooooooo`10oooo00<0003oooooool0KOooo`00]Oooo`030000oooooooo
047oool20000KOooo`00]Oooo`030000oooooooo04?oool00`000?ooooooo`1Zoooo002eoooo00<0
003oooooool0A?ooo`030000oooooooo06Woool00;Goool00`000?ooooooo`0Qoooo00<0003ooooo
ool08Oooo`030000oooooooo06Soool00;Goool00`000?ooooooo`0Roooo00<0003oooooool08Ooo
o`030000oooooooo06Ooool00;Goool00`000?ooooooo`0Roooo00<0003oooooool08_ooo`030000
oooooooo06Koool00;Goool00`000?ooooooo`0Roooo00<0003oooooool08oooo`030000oooooooo
06Goool00;Goool200009?ooo`030000oooooooo02;oool00`000?ooooooo`1Uoooo002eoooo00<0
003oooooool08oooo`030000oooooooo02?oool00`000?ooooooo`1Toooo002eoooo00<0003ooooo
ool09?ooo`030000oooooooo02?oool20000I?ooo`00]Oooo`030000oooooooo02Goool00`000?oo
ooooo`0Toooo00<0003oooooool0HOooo`00]Oooo`030000oooooooo02Goool00`000?ooooooo`0U
oooo00<0003oooooool0H?ooo`00]Oooo`030000oooooooo01Soool00`000?ooooooo`0:oooo00<0
003oooooool09_ooo`030000oooooooo05ooool00;Goool00`000?ooooooo`0Hoooo00<0003ooooo
ool02oooo`030000oooooooo02Koool00`000?ooooooo`1Noooo002eoooo00<0003oooooool06Ooo
o`030000oooooooo00_oool00`000?ooooooo`0Voooo00<0003oooooool0GOooo`00]Oooo`030000
oooooooo01Woool00`000?ooooooo`0;oooo00<0003oooooool09oooo`030000oooooooo05coool0
0;Goool00`000?ooooooo`0Ioooo00<0003oooooool03?ooo`030000oooooooo02Ooool00`000?oo
ooooo`1Koooo002eoooo0P0001?oool00`000?ooooooo`05oooo00<0003oooooool02oooo`030000
oooooooo02Soool20000Foooo`00]Oooo`030000oooooooo01?oool00`000?ooooooo`04oooo00<0
003oooooool03?ooo`030000oooooooo02Woool00`000?ooooooo`1Hoooo002eoooo00<0003ooooo
ool04oooo`030000oooooooo00Goool00`000?ooooooo`0;oooo00<0003oooooool0:_ooo`030000
oooooooo05Ooool00;Goool00`000?ooooooo`0?oooo00D0003oooooooooool000001oooo`030000
oooooooo00coool00`000?ooooooo`0Zoooo00<0003oooooool0E_ooo`00]Oooo`030000oooooooo
00ooool00`000?ooooooo`02oooo00<0003oooooool01?ooo`030000oooooooo00goool00`000?oo
ooooo`0Zoooo00<0003oooooool0EOooo`00]Oooo`030000oooooooo00coool010000?ooooooo`00
00Coool00`000?ooooooo`05oooo00<0003oooooool03?ooo`030000oooooooo02_oool00`000?oo
ooooo`1Doooo002eoooo00<0003oooooool03?ooo`040000oooooooo00001?ooo`030000oooooooo
00Goool00`000?ooooooo`0<oooo00<0003oooooool0;?ooo`030000oooooooo05?oool00;Goool0
0`000?ooooooo`0:oooo00@0003oooooool00002oooo00<0003oooooool00_ooo`030000oooooooo
00Coool00`000?ooooooo`0=oooo00<0003oooooool0;?ooo`030000oooooooo05;oool00;Goool0
0`000?ooooooo`0:oooo0P000005oooo0000oooooooo000000Coool00`000?ooooooo`05oooo00<0
003oooooool03Oooo`030000oooooooo02coool20000D_ooo`00]Oooo`030000oooooooo00Woool0
1@000?ooo`000?ooo`000002oooo00<0003oooooool00_ooo`030000oooooooo00Goool00`000?oo
ooooo`0=oooo00<0003oooooool0;_ooo`030000oooooooo04ooool00;Goool200002_ooo`050000
oooo0000oooo000000;oool00`000?ooooooo`02oooo00<0003oooooool01_ooo`030000oooooooo
00goool00`000?ooooooo`0^oooo00<0003oooooool0C_ooo`00]Oooo`030000oooooooo00Woool0
1@000?ooo`000?ooo`000003oooo00@0003oooooooooool200001oooo`030000oooooooo00goool0
0`000?ooooooo`0_oooo00<0003oooooool0COooo`00]Oooo`030000oooooooo00Woool01@000?oo
o`000?ooo`000003oooo00<0003oooooool00_ooo`030000oooooooo00Goool00`000?ooooooo`0>
oooo00<0003oooooool0;oooo`030000oooooooo04coool00;Goool00`000?ooooooo`09oooo0`00
00;oool010000?ooooooo`0000Coool00`000?ooooooo`06oooo00<0003oooooool03Oooo`030000
oooooooo02ooool00`000?ooooooo`1<oooo002eoooo00<0003oooooool02_ooo`800002oooo00@0
003oooooool00004oooo00<0003oooooool01_ooo`030000oooooooo00koool00`000?ooooooo`0_
oooo00<0003oooooool0Boooo`00]Oooo`030000oooooooo00[oool3000000Goool0003oooooool0
00001Oooo`030000oooooooo00Goool00`000?ooooooo`0?oooo00<0003oooooool0;oooo`030000
oooooooo04[oool00;Goool00`000?ooooooo`0:oooo00D0003oool0003oool000000oooo`030000
oooooooo00;oool00`000?ooooooo`05oooo00<0003oooooool03oooo`030000oooooooo033oool0
0`000?ooooooo`19oooo002[oooo1@0000Goool00`000?ooooooo`0:oooo00D0003oool0003oool0
00000oooo`030000oooooooo00;oool00`000?ooooooo`06oooo00<0003oooooool03_ooo`030000
oooooooo037oool20000BOooo`00[Oooo`030000oooooooo00Goool00`000?ooooooo`0:oooo00<0
003oool000000_ooo`040000oooooooo00001?ooo`030000oooooooo00Koool00`000?ooooooo`0?
oooo00<0003oooooool0<_ooo`030000oooooooo04Koool00:goool00`000?ooooooo`05oooo00<0
003oooooool02_ooo`030000oooo000000;oool010000?ooooooo`0000Goool00`000?ooooooo`06
oooo00<0003oooooool03oooo`030000oooooooo03;oool00`000?ooooooo`15oooo000Coooo2`00
00Woool;00002_ooo`/00002oooo00<0003oooooool01?ooo`/00009oooo300000Woool;00002Ooo
o`/00002oooo00<0003oooooool00_ooo`030000oooooooo00`00007oooo30000004oooo0000oooo
00000_ooo`030000oooooooo00`00003oooo00<0003oooooool00oooo`/000000oooo`000?ooo`06
oooo300000Woool;00002Oooo`/0000:oooo2`0000Woool;00006?ooo`00B?ooo`030000oooooooo
03Coool00`000?ooooooo`0?oooo00<0003oooooool01_ooo`030000oooooooo00;oool01`000?oo
ooooooooo`000?ooo`000007oooo00<0003oooooool01Oooo`030000oooooooo0;3oool004Ooool0
0`000?ooooooo`0doooo00<0003oooooool03oooo`030000oooooooo00Koool00`000?ooooooo`03
oooo00@0003oooooool00002oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`2`oooo0015oooo0P0003Ooool00`000?ooooooo`0?oooo00<0003oooooool01_ooo`030000
oooooooo00?oool010000?ooooooo`0000;oool00`000?ooooooo`03oooo0`0000Ooool00`000?oo
ooooo`2`oooo0014oooo00<0003oooooool0=_ooo`030000oooooooo00ooool00`000?ooooooo`07
oooo00<0003oooooool00_ooo`050000oooooooooooo000000;oool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo0;3oool004?oool00`000?ooooooo`0foooo00<0003ooooo
ool04?ooo`030000oooooooo00Koool00`000?ooooooo`03oooo00D0003oooooooooool000000_oo
o`030000oooooooo00goool00`000?ooooooo`2`oooo0012oooo00<0003oooooool0=oooo`030000
oooooooo013oool00`000?ooooooo`06oooo00<0003oooooool00oooo`070000oooooooooooo0000
oooo0000013oool00`000?ooooooo`2`oooo0011oooo00<0003oooooool0=oooo`030000oooooooo
017oool00`000?ooooooo`06oooo00<0003oooooool00oooo`070000oooooooooooo0000oooo0000
013oool00`000?ooooooo`2`oooo0010oooo00<0003oooooool0=oooo`030000oooooooo017oool0
0`000?ooooooo`07oooo00<0003oooooool00_ooo`050000oooooooooooo000000;oool00`000?oo
ooooo`0>oooo00<0003oooooool0/?ooo`00?oooo`030000oooooooo03Soool00`000?ooooooo`0A
oooo00<0003oooooool01oooo`030000oooooooo00;oool01@000?ooooooooooo`000002oooo00<0
003oooooool03_ooo`030000oooooooo0;3oool003koool00`000?ooooooo`0hoooo00<0003ooooo
ool04Oooo`030000oooooooo00Ooool00`000?ooooooo`03oooo00D0003oooooooooool000000_oo
o`030000oooooooo00koool20000/Oooo`00??ooo`80000koooo00<0003oooooool04Oooo`030000
oooooooo00Ooool00`000?ooooooo`03oooo00D0003oooooooooool000000_ooo`030000oooooooo
00koool00`000?ooooooo`2`oooo000koooo00<0003oooooool0>_ooo`030000oooooooo017oool0
0`000?ooooooo`08oooo00<0003oooooool00oooo`050000oooooooooooo000000;oool00`000?oo
ooooo`0>oooo00<0003oooooool0/?ooo`00>_ooo`030000oooooooo03_oool00`000?ooooooo`0A
oooo00<0003oooooool02?ooo`030000oooooooo00;oool01@000?ooooooooooo`000002oooo00<0
003oooooool03oooo`030000oooooooo0;3oool003Woool00`000?ooooooo`0koooo00<0003ooooo
ool04_ooo`030000oooooooo00Ooool00`000?ooooooo`03oooo00D0003oooooooooool000000_oo
o`030000oooooooo00ooool00`000?ooooooo`2`oooo000hoooo00<0003oooooool0??ooo`030000
oooooooo01;oool00`000?ooooooo`07oooo00<0003oooooool00oooo`050000oooooooooooo0000
00;oool00`000?ooooooo`0?oooo00<0003oooooool0/?ooo`00=oooo`030000oooooooo03coool0
0`000?ooooooo`0Boooo00<0003oooooool01oooo`030000oooooooo00Coool01@000?oooooooooo
o`000002oooo00<0003oooooool03oooo`030000oooooooo0;3oool003Koool00`000?ooooooo`0m
oooo00<0003oooooool04_ooo`030000oooooooo00Ooool00`000?ooooooo`03oooo00<0003ooooo
ool00_ooo`030000oooooooo01;oool00`000?ooooooo`2`oooo000eoooo00<0003oooooool0?Ooo
o`030000oooooooo01;oool00`000?ooooooo`08oooo00<0003oooooool00oooo`030000oooooooo
00;oool00`000?ooooooo`0Boooo00<0003oooooool0/?ooo`00=?ooo`030000oooooooo03koool0
0`000?ooooooo`0Boooo00<0003oooooool02?ooo`030000oooooooo00?oool01@000?oooooooooo
o`00000Eoooo00<0003oooooool0/?ooo`00<oooo`030000oooooooo03koool00`000?ooooooo`0B
oooo00<0003oooooool02Oooo`030000oooooooo00?oool01@000?ooooooooooo`00000Eoooo0P00
0;7oool003;oool00`000?ooooooo`0ooooo00<0003oooooool04_ooo`030000oooooooo00Soool0
0`000?ooooooo`04oooo00<0003oooooool05oooo`030000oooooooo0;3oool0037oool00`000?oo
ooooo`0ooooo00<0003oooooool04oooo`030000oooooooo00Soool00`000?ooooooo`04oooo00<0
003oooooool05oooo`030000oooooooo0;3oool0033oool00`000?ooooooo`10oooo00<0003ooooo
ool04oooo`030000oooooooo00Soool00`000?ooooooo`03oooo00<0003oooooool06?ooo`030000
oooooooo0;3oool002ooool00`000?ooooooo`10oooo00<0003oooooool05?ooo`030000oooooooo
00Soool00`000?ooooooo`03oooo00<0003oooooool06?ooo`030000oooooooo0;3oool002koool0
0`000?ooooooo`10oooo00<0003oooooool05?ooo`030000oooooooo00Soool00`000?ooooooo`04
oooo00<0003oooooool06?ooo`030000oooooooo0;3oool002goool00`000?ooooooo`11oooo00<0
003oooooool05?ooo`030000oooooooo00Soool00`000?ooooooo`0Ooooo00<0003oooooool0/?oo
o`00;?ooo`030000oooooooo047oool00`000?ooooooo`0Doooo00<0003oooooool02Oooo`030000
oooooooo01ooool00`000?ooooooo`2`oooo000Zoooo0P0004Coool00`000?ooooooo`0Doooo00<0
003oooooool02?ooo`030000oooooooo023oool00`000?ooooooo`2`oooo000Yoooo00<0003ooooo
ool0@oooo`030000oooooooo01Coool00`000?ooooooo`09oooo00<0003oooooool08?ooo`030000
oooooooo0;3oool002Soool00`000?ooooooo`14oooo00<0003oooooool05?ooo`030000oooooooo
00Woool00`000?ooooooo`0Poooo0P000;7oool002Ooool00`000?ooooooo`14oooo00<0003ooooo
ool05Oooo`030000oooooooo00Woool00`000?ooooooo`0Poooo00<0003oooooool0/?ooo`009_oo
o`030000oooooooo04Goool00`000?ooooooo`0Eoooo00<0003oooooool02?ooo`030000oooooooo
027oool00`000?ooooooo`2`oooo000Uoooo00<0003oooooool0AOooo`030000oooooooo01Goool0
0`000?ooooooo`09oooo00<0003oooooool08Oooo`030000oooooooo0;3oool002Coool00`000?oo
ooooo`16oooo00<0003oooooool05Oooo`030000oooooooo02goool00`000?ooooooo`2`oooo000S
oooo00<0003oooooool0A_ooo`030000oooooooo01Goool00`000?ooooooo`0^oooo00<0003ooooo
ool0/?ooo`008Oooo`800019oooo00<0003oooooool05Oooo`030000oooooooo02koool00`000?oo
ooooo`2`oooo000Poooo00<0003oooooool0B?ooo`030000oooooooo01Goool00`000?ooooooo`0_
oooo00<0003oooooool0/?ooo`007oooo`030000oooooooo04Soool00`000?ooooooo`0Foooo00<0
003oooooool0;oooo`030000oooooooo0;3oool001koool00`000?ooooooo`19oooo00<0003ooooo
ool05_ooo`030000oooooooo02ooool00`000?ooooooo`2`oooo000Moooo00<0003oooooool0BOoo
o`030000oooooooo01Ooool00`000?ooooooo`0_oooo0P000;7oool001coool00`000?ooooooo`1:
oooo00<0003oooooool05_ooo`030000oooooooo033oool00`000?ooooooo`2`oooo000Koooo00<0
003oooooool0B_ooo`030000oooooooo01Ooool00`000?ooooooo`0`oooo00<0003oooooool0/?oo
o`006_ooo`030000oooooooo04_oool00`000?ooooooo`0Foooo00<0003oooooool0<Oooo`030000
oooooooo0;3oool001Woool00`000?ooooooo`1;oooo00<0003oooooool05oooo`030000oooooooo
037oool00`000?ooooooo`2`oooo000Hoooo00<0003oooooool0C?ooo`030000oooooooo01Koool0
0`000?ooooooo`0boooo00<0003oooooool0/?ooo`005oooo`030000oooooooo04coool00`000?oo
ooooo`0Goooo00<0003oooooool0<_ooo`030000oooooooo0;3oool001Koool00`000?ooooooo`1=
oooo00<0003oooooool05oooo`030000oooooooo01Soool500001?ooo`800005oooo100000Koool0
0`000?ooooooo`2`oooo000Eoooo00<0003oooooool0COooo`030000oooooooo01Soool00`000?oo
ooooo`0Joooo00<0003oooooool01?ooo`800004oooo00<0003oooooool00_ooo`030000oooooooo
00?oool00`000?ooooooo`2`oooo000Doooo00<0003oooooool0C_ooo`030000oooooooo01Soool0
0`000?ooooooo`0Joooo00<0003oooooool03oooo`030000oooooooo00?oool00`000?ooooooo`2`
oooo000Coooo00<0003oooooool0C_ooo`030000oooooooo01Soool00`000?ooooooo`0Koooo00<0
003oooooool03oooo`030000oooooooo00?oool30000/?ooo`00I?ooo`030000oooooooo03Koool0
0`000?ooooooo`0;oooo100000Koool00`000?ooooooo`2`oooo001Soooo00<0003oooooool0=ooo
o`030000oooooooo00_oool00`000?ooooooo`07oooo00<0003oooooool0/?ooo`00Hoooo`030000
oooooooo03Goool300003Oooo`030000oooooooo00Ooool00`000?ooooooo`2`oooo001Roooo00<0
003oooooool0>?ooo`030000oooooooo00_oool500001Oooo`030000oooooooo0;3oool0067oool0
0`000?ooooooo`1Aoooo00<0003oooooool0/?ooo`00HOooo`030000oooooooo057oool00`000?oo
ooooo`2`oooo001Poooo00<0003oooooool0D_ooo`030000oooooooo0;3oool005ooool00`000?oo
ooooo`1Coooo00<0003oooooool0/?ooo`00Goooo`030000oooooooo05?oool00`000?ooooooo`2`
oooo001Noooo00<0003oooooool0E?ooo`80002aoooo001Noooo00<0003oooooool0E?ooo`030000
oooooooo0;3oool005goool00`000?ooooooo`1Eoooo00<0003oooooool0/?ooo`00GOooo`030000
oooooooo05Goool00`000?ooooooo`2`oooo001Loooo00<0003oooooool0E_ooo`030000oooooooo
0;3oool005coool00`000?ooooooo`1Foooo00<0003oooooool0/?ooo`00Foooo`030000oooooooo
05Ooool00`000?ooooooo`2`oooo001Koooo00<0003oooooool0Eoooo`030000oooooooo0;3oool0
05[oool00`000?ooooooo`1Hoooo00<0003oooooool0/?ooo`00F_ooo`030000oooooooo05Soool0
0`000?ooooooo`2`oooo001Ioooo00<0003oooooool0FOooo`80002aoooo001Ioooo00<0003ooooo
ool0FOooo`030000oooooooo0;3oool005Soool00`000?ooooooo`1Joooo00<0003oooooool0/?oo
o`00F?ooo`030000oooooooo05[oool00`000?ooooooo`2`oooo001Goooo00<0003oooooool0Fooo
o`030000oooooooo0;3oool005Koool00`000?ooooooo`1Loooo00<0003oooooool0/?ooo`00E_oo
o`030000oooooooo05coool00`000?ooooooo`2`oooo001Eoooo00<0003oooooool0GOooo`030000
oooooooo0;3oool005Goool00`000?ooooooo`1Moooo00<0003oooooool0/?ooo`00E?ooo`030000
oooooooo05koool00`000?ooooooo`2`oooo001Doooo00<0003oooooool0G_ooo`80002aoooo001C
oooo00<0003oooooool0Goooo`030000oooooooo0;3oool005?oool00`000?ooooooo`1Ooooo00<0
003oooooool0/?ooo`00D_ooo`030000oooooooo063oool00`000?ooooooo`2`oooo001Boooo00<0
003oooooool0H?ooo`030000oooooooo0;3oool0057oool00`000?ooooooo`1Qoooo00<0003ooooo
ool0/?ooo`00DOooo`030000oooooooo067oool00`000?ooooooo`2`oooo001@oooo00<0003ooooo
ool0H_ooo`030000oooooooo0;3oool004ooool00`000?ooooooo`1Soooo00<0003oooooool0/?oo
o`00Coooo`030000oooooooo06?oool00`000?ooooooo`2`oooo001>oooo00<0003oooooool0I?oo
o`80002aoooo001=oooo00<0003oooooool0IOooo`030000oooooooo0;3oool004goool00`000?oo
ooooo`1Uoooo00<0003oooooool0/?ooo`00C?ooo`030000oooooooo06Koool00`000?ooooooo`2`
oooo001<oooo00<0003oooooool0I_ooo`030000oooooooo0;3oool004_oool00`000?ooooooo`1W
oooo00<0003oooooool0/?ooo`00Boooo`030000oooooooo06Ooool00`000?ooooooo`2`oooo001;
oooo00<0003oooooool0G?ooo`D00006oooo00<0003oooooool0/?ooo`00B_ooo`030000oooooooo
05goool01@000?ooooooooooo`000006oooo00<0003oooooool0/?ooo`00B_ooo`030000oooooooo
05koool00`000?ooooooo`07oooo00<0003oooooool0/?ooo`00BOooo`030000oooooooo063oool0
0`000?ooooooo`06oooo0`000;3oool00:goool00`000?ooooooo`05oooo00<0003oooooool0/?oo
o`00[_ooo`030000oooooooo00Coool00`000?ooooooo`2`oooo002Zoooo00D0003oooooooooool0
00001_ooo`030000oooooooo0;3oool00:_oool300001oooo`030000oooooooo0;3oool00;Goool0
0`000?ooooooo`2`oooo0000\
\>"],
  ImageRangeCache->{{{0, 359}, {221.375, 0}} -> {-1.67937, -0.154828, \
0.0115739, 0.0124846}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Display["\<xE1-x.eps\>", \ %, \ "\<EPS\>"]\)], "Input"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowSize->{1016, 654},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 60, 1, 35, "Input"],
Cell[1780, 52, 61, 1, 35, "Input"],
Cell[1844, 55, 61, 1, 35, "Input"],
Cell[1908, 58, 63, 1, 35, "Input"],
Cell[1974, 61, 63, 1, 35, "Input"],
Cell[2040, 64, 63, 1, 35, "Input"],
Cell[2106, 67, 63, 1, 35, "Input"],
Cell[2172, 70, 63, 1, 35, "Input"],
Cell[2238, 73, 63, 1, 35, "Input"],
Cell[2304, 76, 63, 1, 35, "Input"],
Cell[2370, 79, 73, 1, 35, "Input"],
Cell[2446, 82, 75, 1, 35, "Input"],
Cell[2524, 85, 77, 1, 35, "Input"],
Cell[2604, 88, 77, 1, 35, "Input"],
Cell[2684, 91, 77, 1, 35, "Input"],
Cell[2764, 94, 77, 1, 35, "Input"],
Cell[2844, 97, 77, 1, 35, "Input"],
Cell[2924, 100, 122, 3, 35, "Input"],

Cell[CellGroupData[{
Cell[3071, 107, 116, 2, 35, "Input"],
Cell[3190, 111, 29478, 901, 233, 9528, 650, "GraphicsData", "PostScript", \
"Graphics"],
Cell[32671, 1014, 130, 3, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[32838, 1022, 75, 1, 35, "Input"],
Cell[32916, 1025, 130, 3, 35, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

